/*- ManagerDetachListener -
 * we will remove the row in the device table that holds the information 
 * for the detached device
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.event.DetachEvent;
import com.phidgets.event.DetachListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ManagerDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTable deviceTbl;
    
    /** Creates a new instance of ManagerDetachListener */
    public ManagerDetachListener(JFrame appFrame, JTable deviceTbl) {
        this.appFrame = appFrame;
        this.deviceTbl = deviceTbl;
    }

    public void detached(DetachEvent ae) {
        Vector table = ((DefaultTableModel)deviceTbl.getModel()).getDataVector();
        
        try
        {
            for(int i = 0; i < table.size(); i++)
            {
                Vector row = (Vector)table.elementAt(i);
                if(row.elementAt(1).equals(Integer.toString(ae.getSource().getSerialNumber())))
                {
                    ((DefaultTableModel)deviceTbl.getModel()).removeRow(i);
                }
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
        
    }
    
}
